'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Abbruch_Click()
On Error GoTo Err_Button_Abbruch_Click


    DoCmd.Close

Exit_Button_Abbruch_Click:
    Exit Sub

Err_Button_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Button_Abbruch_Click
    
End Sub

Private Sub Button_OK_Click()

    'Variablen deklarieren
    Dim dbs As Database, rst As Recordset
    Dim rstGebuehren As Recordset
    Dim FilterGebuehr As String
    
    'Gltigkeitsprfungen
    If (IsNull(Me.gilt_ab.Value) Or (Trim(Me.gilt_ab.Value) = "")) Then
        MsgBox "Bitte geben Sie ein Gilt-ab-Datum ein!", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then
        MsgBox "Bitte geben Sie einen Stundensatz ein!", vbCritical, "Fehler"
        Me.Stundensatz.SetFocus
        Exit Sub
    End If
            
    'Hinweis zum Warten anzeigen
    'DoCmd.OpenForm "Bitte_warten"
    'Forms![Bitte_warten].Repaint
    
    'Filterzeichenkette vorbereiten
'    If GebuehrArt = "Allgemein" Then
    FilterGebuehr = "SELECT * FROM Preise WHERE ([gilt_ab] = #"
'    Else
'        FilterGebuehr = "SELECT * FROM Preise WHERE [gilt_ab] = #"
'    End If
    FilterGebuehr = FilterGebuehr & Month(Me.gilt_ab.Value) & "/" & Day(Me.gilt_ab.Value) & "/" & Year(Me.gilt_ab.Value) & "#"
    
    'Evtl. auf einen Kunden einschrnken
    If FormularName = "Kunden" Then
        'FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kunde]=" & KundenNrIntern
        FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kunde]=" & AktKunde
    Else
        FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kunde]=" & SatzKontaktDummy
    End If
'MsgBox AktKunde

    'Evtl. auf eine Kategorie einschrnken
    'je nachdem, von wo die Preiseingabe aufgerufen wurde...
    If (FormularName = "Kunden") Then
        If (ReKundePreisJeKategorie = True) And (AktKategorie <> 0) Then
            FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        Else
            FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
        End If
    End If
    If (FormularName = "Einstellungen_2") Then
        If (RePreisJeKategorie = True) And (AktKategorie <> 0) Then
            FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kategorie]=" & AktKategorie & ")"
        Else
            FilterGebuehr = FilterGebuehr & ") AND ([lfd_Nr_Kategorie]=" & SatzKategorieDummy & ")"
        End If
    End If
        
    'Evtl. auf einen Kalender einschrnken
    'je nachdem, von wo die Preiseingabe aufgerufen wurde...
    If (FormularName = "Kunden") Then
        If (ReKundePreisJeKalender = True) And (AktKalender <> 0) Then
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
        Else
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=0)"
        End If
    End If
    If (FormularName = "Einstellungen_2") Then
        If (RePreisJeKalender = True) And (AktKalender <> 0) Then
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=" & AktKalender & ")"
        Else
            FilterGebuehr = FilterGebuehr & " AND ([lfd_Nr_Kalender]=0)"
        End If
    End If
        
        
        
    
    'Tabelle ffnen und nachsehen, ob Datum bereis vorhanden ist
    On Error GoTo ErrorGebhrAnlegenFehler
    Set dbs = CurrentDb
    Set rstGebuehren = dbs.OpenRecordset(FilterGebuehr)
    If (rstGebuehren.RecordCount) = 0 Then
        'Gebhr anlegen
        rstGebuehren.AddNew
        rstGebuehren!gilt_ab = Me.gilt_ab.Value
        rstGebuehren!Std_Satz = Me.Stundensatz.Value
        rstGebuehren!Jahr = Year(Me.gilt_ab.Value)
        rstGebuehren!Monat = Month(Me.gilt_ab.Value)
        rstGebuehren!Tag = Day(Me.gilt_ab.Value)
        'Kundennummer einstellen
        If FormularName = "Kunden" Then
            'rstGebuehren!lfd_Nr_Kunde = KundenNrIntern
            rstGebuehren!lfd_Nr_Kunde = AktKunde
        Else
            rstGebuehren!lfd_Nr_Kunde = SatzKontaktDummy
        End If
        'Kategorienummer einstellen
        If FormularName = "Kunden" Then
            If (ReKundePreisJeKategorie = True) And (AktKategorie <> 0) Then
                rstGebuehren!lfd_Nr_Kategorie = AktKategorie
            Else
                rstGebuehren!lfd_Nr_Kategorie = SatzKategorieDummy
            End If
        End If
        If FormularName = "Einstellungen_2" Then
            If (RePreisJeKategorie = True) And (AktKategorie <> 0) Then
                rstGebuehren!lfd_Nr_Kategorie = AktKategorie
            Else
                rstGebuehren!lfd_Nr_Kategorie = SatzKategorieDummy
            End If
        End If
        'Kalendernummer einstellen
        If FormularName = "Kunden" Then
            If (ReKundePreisJeKalender = True) And (AktKalender <> 0) Then
                rstGebuehren!lfd_Nr_Kalender = AktKalender
            Else
                rstGebuehren!lfd_Nr_Kalender = 0
            End If
        End If
        If FormularName = "Einstellungen_2" Then
            If (RePreisJeKalender = True) And (AktKalender <> 0) Then
                rstGebuehren!lfd_Nr_Kalender = AktKalender
            Else
                rstGebuehren!lfd_Nr_Kalender = 0
            End If
        End If
        rstGebuehren.Update
        rstGebuehren.Close
    Else
        'Hinweis zum Warten schlieen
        'DoCmd.Close acForm, "Bitte_warten", acSaveYes
        'Forms![Bitte_warten].Repaint
        
        'wenn Datum bereits vorhanden
        MsgBox "Das Gilt-ab-Datum ist bereits vorhanden! Bitte geben Sie ein anderes Datum ein.", vbCritical, "Fehler"
        Me.gilt_ab.SetFocus
        Exit Sub
    End If
    
    
ExitGebuehrAnlegen:
    
    On Error Resume Next
    
    Set rstGebuehren = Nothing
    Set dbs = Nothing
    
    'Aufrufendes Formular zwecks Aktualisierung schlieen und wieder ffnen
    'DoCmd.Close acForm, FormularName, acSaveYes
    'DoCmd.OpenForm FormularName, , , , , , AktKunde
    'Anzeige aktualisieren
    If FormularName = "Kunden" Then Forms![Kunden].[Gebuehren].Form.Requery
    'If FormularName = "Kunden" Then Forms![Kunden].[Preise].Form.Requery
    If FormularName = "Einstellungen_2" Then Forms![Einstellungen_2].[Preise].Form.Requery
    'sich selbst schlieen
    DoCmd.Close acForm, "Gebhr_neu", acSaveYes
    
    Exit Sub
    
    
ErrorGebhrAnlegenFehler:
        MsgBox "Beim Speichern der Gebhr trat ein Fehler auf!", vbCritical, "Fehler"
        MsgBox err.Description
        Resume ExitGebuehrAnlegen

End Sub

Private Sub Form_Open(Cancel As Integer)
    'aktuelles Whrungsformat des Systems einstellen
    Me.Stundensatz.Format = "Currency"
    
    Me.gilt_ab.InputMask = "00/00/0099;0;_"
End Sub

Private Sub Stundensatz_Exit(Cancel As Integer)
    If (IsNull(Me.Stundensatz.Value) Or (Trim(Me.Stundensatz.Value) = "")) Then Exit Sub
    Me.Stundensatz.Value = Format(Me.Stundensatz.Value, "#,##0.0000")
End Sub
